## How to contribute to Bagisto


### **Bug Reporting**

1. Verify that the bug was not already reported by searching on GitHub in the [Issues section](https://github.com/bagisto/bagisto/issues)
If you're unable to find an open issue, [open a new one](https://github.com/bagisto/bagisto/issues/new?assignees=&labels=&template=1_Bug_report.md).

2. Verify that the bug you are reporting is a general issue and not specific to your individual setup.  
For individual issues please use the [Community Forum](https://forums.bagisto.com/).

#### **Did you fix a bug?**

1. To provide a code contribution for an issue you will need to set up your own fork of the [Bagisto repository](https://github.com/bagisto/bagisto).  
Make your code changes, commit the changes and make a [Pull Request](https://help.github.com/articles/about-pull-requests/) to the [Bagisto repository](https://github.com/bagisto/bagisto).  
2. Separate each fix into a new branch in your repository and name it with the issue ID e.g. issue-1234.
3. When committing to your individual branch, please try and use the following as your commit message  
```Fixed #1234 - <the subject of the issue>```  
4. Please follow the pull request [template](https://github.com/bagisto/bagisto/blob/master/.github/PULL_REQUEST_TEMPLATE.md) as much as possible.

### **Did you create a new feature or enhancement?**
1. To provide a code contribution for a new feature or enhancement a [feature request](https://github.com/bagisto/bagisto/issues/new?assignees=&labels=&template=2_Feature_request.md) report should be created in case it doesn't exist.
2. To contribute a feature to Bagisto, you must create a forked repository and set up your git and development environment.
3. Make sure your commit messages are relevant and descriptive.
4. Please follow the pull request [template](https://github.com/bagisto/bagisto/blob/master/.github/PULL_REQUEST_TEMPLATE.md) as much as possible.
