<?php

return [
    'invalid_vat_format' => 'Данный идентификатор НДС имеет неправильный формат',
    'security-warning'   => 'Обнаружена подозрительная активность!!!',
    'nothing-to-delete'  => 'Нечего удалять',

    'layouts' => [
        'my-account'            => 'Мой счет',
        'profile'               => 'Профиль',
        'address'               => 'Адрес',
        'reviews'               => 'Отзывы',
        'wishlist'              => 'список желаний',
        'orders'                => 'Заказы',
        'downloadable-products' => 'Загружаемые продукты',
    ],

    'common' => [
        'error'              => 'Что-то пошло не так. Пожалуйста, повторите попытку позже.',
        'image-upload-limit' => 'Максимальный размер загружаемого изображения – 2 МБ',
        'no-result-found'    => 'Нам не удалось найти никаких записей.',
    ],

    'home' => [
        'page-title'          => config('app.name') . ' - Home',
        'featured-products'   => 'Рекомендуемые товары',
        'new-products'        => 'Новые продукты',
        'verify-email'        => 'Подтвердите свою учетную запись электронной почты',
        'resend-verify-email' => 'Выслать повторно письмо для подтверждения',
    ],

    'header' => [
        'title'         => 'Счет',
        'dropdown-text' => 'Управление корзиной, заказами и списком желаний',
        'sign-in'       => 'Войти',
        'sign-up'       => 'Зарегистрироваться',
        'account'       => 'Счет',
        'cart'          => 'Корзина',
        'profile'       => 'Профиль',
        'wishlist'      => 'список желаний',
        'cart'          => 'Корзина',
        'logout'        => 'Выйти',
        'search-text'   => 'Искать товары здесь',
    ],

    'minicart' => [
        'view-cart' => 'Посмотреть корзину',
        'checkout'  => 'Проверить',
        'cart'      => 'Корзина',
        'zero'      => '0',
    ],

    'footer' => [
        'subscribe-newsletter' => 'Подписаться на рассылку',
        'subscribe'            => 'Подписаться',
        'locale'               => 'локаль',
        'currency'             => 'Валюта',
    ],

    'subscription' => [
        'unsubscribe'    => 'Отписаться',
        'subscribe'      => 'Подписаться',
        'subscribed'     => 'Теперь вы подписаны на подписку по электронной почте.',
        'not-subscribed' => 'Вы не можете быть подписаны на электронные письма о подписке, попробуйте еще раз..',
        'already'        => 'Вы уже подписаны на наш список подписки.',
        'unsubscribed'   => 'Вы отписались от подписных писем.',
        'already-unsub'  => 'Вы уже отписались.',
        'not-subscribed' => 'Ошибка! Почта не может быть отправлена ​​в настоящее время, повторите попытку позже.',
    ],

    'search' => [
        'no-results'          => 'Результатов не найдено',
        'page-title'          => config('app.name') . ' - Поиск',
        'found-results'       => 'Результаты поиска найдены',
        'found-result'        => 'Результат поиска найден»',
        'analysed-keywords'   => 'Проанализированные ключевые слова',
        'image-search-option' => 'Вариант поиска изображения',
    ],

    'reviews' => [
        'title'                     => 'Заголовок',
        'add-review-page-title'     => 'Добавить отзыв',
        'write-review'              => 'Написать рецензию',
        'review-title'              => 'Дайте вашему отзыву название',
        'product-review-page-title' => 'Обзор продукта',
        'rating-reviews'            => 'Рейтинг и обзоры',
        'submit'                    => 'ПРЕДСТАВИТЬ',
        'delete-all'                => 'Все отзывы успешно удалены',
        'ratingreviews'             => ':rating Рейтинги и :review Обзоры',
        'star'                      => 'Звезда',
        'percentage'                => ':процент %',
        'id-star'                   => 'звезда',
        'name'                      => 'Имя',
    ],

    'customer' => [
        'compare' => [
            'text'                  => 'Сравнивать',
            'compare_similar_items' => 'Сравнить похожие товары',
            'add-tooltip'           => 'Добавить товар в список сравнения',
            'added'                 => 'Товар успешно добавлен в список сравнения',
            'already_added'         => 'Товар уже добавлен в список сравнения',
            'removed'               => 'Товар успешно удален из списка сравнения',
            'removed-all'           => 'Все элементы успешно удалены из списка сравнения',
            'confirm-remove-all'    => 'Вы уверены, что хотите удалить все элементы сравнения?',
            'empty-text'            => "У вас нет товаров в списке сравнения",
            'product_image'         => 'Изображение продукта',
            'actions'               => 'Действия',
        ],

        'signup-text' => [
            'account_exists' => 'Уже есть аккаунт',
            'title'          => 'Войти',
        ],

        'signup-form' => [
            'page-title'                  => '«Создать новую учетную запись клиента»',
            'title'                       => 'Зарегистрироваться',
            'firstname'                   => 'Имя',
            'lastname'                    => 'Фамилия',
            'email'                       => 'Эл. адрес',
            'password'                    => 'Пароль',
            'confirm_pass'                => 'Подтвердить Пароль',
            'button_title'                => 'Регистр',
            'agree'                       => 'Согласен',
            'terms'                       => 'Условия',
            'conditions'                  => 'Условия',
            'using'                       => 'используя этот веб-сайт',
            'agreement'                   => 'Соглашение',
            'subscribe-to-newsletter'     => 'Подписаться на новостную рассылку',
            'success'                     => 'Учетная запись успешно создана.',
            'success-verify'              => 'Учетная запись успешно создана, электронное письмо отправлено для подтверждения.',
            'success-verify-email-unsent' => 'Учетная запись успешно создана, но электронное письмо с подтверждением не отправлено.',
            'failed'                      => 'Ошибка! Не удается создать учетную запись. Повторите попытку позже.',
            'already-verified'            => 'Ваша учетная запись уже подтверждена. Или попробуйте отправить новое электронное письмо с подтверждением еще раз.',
            'verification-not-sent'       => 'Ошибка! Проблема с отправкой письма с подтверждением. Повторите попытку позже.',
            'verification-sent'           => "Письмо с подтверждением отправлено",
            'verified'                    => 'Ваша учетная запись подтверждена, попробуйте войти сейчас.',
            'verify-failed'               => '«Мы не можем проверить вашу учетную запись электронной почты.»',
            'dont-have-account'           => 'У вас нет аккаунта у нас.',
            'customer-registration'       => '«Клиент успешно зарегистрирован»',
        ],

        'login-text' => [
            'no_account' => '«Нет учетной записи»',
            'title'      => 'Зарегистрироваться',
        ],

        'login-form' => [
            'page-title'          => 'Вход для клиентов',
            'title'               => 'Войти',
            'email'               => 'Эл. адрес',
            'password'            => 'Пароль',
            'forgot_pass'         => 'Забыл пароль?',
            'button_title'        => 'Войти',
            'remember'            => 'Запомни меня',
            'footer'              => '© Copyright :год Webkul Software, Все права защищены',
            'invalid-creds'       => 'Пожалуйста, проверьте свои учетные данные и повторите попытку.',
            'verify-first'        => 'Сначала подтвердите свою учетную запись электронной почты.',
            'not-activated'       => '«Ваша активация требует одобрения администратора»',
            'resend-verification' => 'Повторно отправить письмо с подтверждением',
            'show-password'       => 'Показать пароль',

        ],

        'forgot-password' => [
            'title'      => 'Восстановить пароль',
            'email'      => 'Эл. адрес',
            'submit'     => '«Отправить письмо для сброса пароля»',
            'page_title' => 'Забыли Ваш пароль ?',
        ],

        'reset-password' => [
            'title'            => 'Сброс пароля',
            'email'            => 'Зарегистрированная электронная почта',
            'password'         => 'Пароль',
            'confirm-password' => 'Подтвердить Пароль',
            'back-link-title'  => '«Вернуться к входу»',
            'submit-btn-title' => 'Сброс пароля',
        ],

        'account' => [
            'dashboard' => 'Редактировать профиль',
            'menu'      => 'Меню',

            'general' => [
                'no'  => 'Нет',
                'yes' => 'Да',
            ],

            'profile' => [
                'index' => [
                    'page-title' => 'Профиль',
                    'title'      => 'Профиль',
                    'edit'       => 'Редактировать',
                ],

                'edit-success' =>'Профиль успешно обновлен.',
                'edit-fail'    => 'Ошибка! Профиль не может быть обновлен, повторите попытку позже.',
                'unmatch'      => 'Старый пароль не подходит.',

                'fname'     => 'Имя',
                'lname'     => 'Фамилия',
                'gender'    => 'Пол',
                'other'     => 'Другой',
                'male'      => 'Мужчина',
                'female'    => 'Женский',
                'dob'       => 'Дата рождения',
                'phone'     => 'Телефон',
                'email'     => 'Эл. адрес',
                'opassword' => 'Старый пароль',
                'password'  => 'Пароль',
                'cpassword' => 'Подтвердить Пароль',
                'submit'    => 'Обновить профиль',

                'edit-profile' => [
                    'title'      => 'Редактировать профиль',
                    'page-title' => 'Редактировать профиль',
                ],
            ],

            'address' => [
                'index' => [
                    'page-title'     => 'Адрес',
                    'title'          => 'Адрес',
                    'add'            => '«Добавить адрес»',
                    'edit'           => 'Редактировать',
                    'empty'          => 'У вас здесь нет сохраненных адресов, попробуйте создать их, нажав кнопку "Добавить".',
                    'create'         => '«Создать адрес»',
                    'delete'         => 'Удалить',
                    'make-default'   => 'Использовать по умолчанию',
                    'default'        => 'По умолчанию',
                    'contact'        => 'Контакт',
                    'confirm-delete' => '«Вы действительно хотите удалить этот адрес?»',
                    'default-delete' => 'Адрес по умолчанию изменить нельзя.',
                    'enter-password' => 'Введите свой пароль.',
                ],

                'create' => [
                    'page-title'     => '«Добавить адрес»',
                    'company_name'   => 'Название организации',
                    'first_name'     => 'Имя',
                    'last_name'      => 'Фамилия',
                    'vat_id'         => 'Код плательщика НДС',
                    'vat_help_note'  => '[Примечание: используйте код страны с идентификатором НДС. Например. ИНВ01234567891]',
                    'title'          => '«Добавить адрес»',
                    'street-address' => 'Адрес улицы',
                    'country'        => 'Страна',
                    'state'          => 'Состояние',
                    'select-state'   => 'Выберите регион, штат или провинцию',
                    'city'           => 'Город',
                    'postcode'       => 'Почтовый Код',
                    'phone'          => 'Телефон',
                    'submit'         => '«Сохранить адрес»',
                    'success'        => 'Адрес был успешно добавлен.',
                    'error'          => 'Невозможно добавить адрес.',
                ],

                'edit' => [
                    'page-title'     => 'Редактировать адрес',
                    'company_name'   => 'Название организации',
                    'first_name'     => 'Имя',
                    'last_name'      => 'Фамилия',
                    'vat_id'         => 'Код плательщика НДС',
                    'title'          => 'Редактировать адрес',
                    'street-address' => 'Адрес улицы',
                    'submit'         => 'Сохранить адрес',
                    'success'        => 'Адрес успешно обновлен.',
                ],

                'delete' => [
                    'success'        => 'Адрес успешно удален',
                    'failure'        => 'Адрес не может быть удален',
                    'wrong-password' => 'Неправильный пароль !',
                ],

                'default-address' => 'Адрес по умолчанию',
            ],

            'order' => [
                'index' => [
                    'page-title'      =>'Заказы',
                    'title'           => 'Заказы',
                    'order_id'        => 'Номер заказа',
                    'date'            => 'Дата',
                    'status'          => 'Положение дел',
                    'total'           => 'Всего',
                    'order_number'    => 'Номер заказа',
                    'processing'      => 'Обработка',
                    'completed'       => 'Завершенный',
                    'canceled'        => '«Отменено»',
                    'closed'          => 'Закрыто',
                    'pending'         => 'В ожидании',
                    'pending-payment' => '«Ожидание платежа»',
                    'fraud'           => 'Мошенничество',
                ],

                'view' => [
                    'page-tile'           => 'Заказ №:order_id',
                    'info'                => 'Информация',
                    'placed-on'           => 'Размещены на',
                    'products-ordered'    => '«Заказаны товары»',
                    'invoices'            => '«Счета»',
                    'shipments'           => '«Поставки»',
                    'SKU'                 => 'Артикул',
                    'product-name'        => 'Имя',
                    'qty'                 => 'кол-во',
                    'item-status'         => '«Статус товара»',
                    'item-ordered'        => 'Заказано (:qty_ordered)',
                    'item-invoice'        => 'Выставлен счет (:qty_invoiced)',
                    'item-shipped'        => 'отправлено (:qty_shipped)',
                    'item-canceled'       => 'Отменено (:qty_canceled)',
                    'item-refunded'       => 'Возвращено (:qty_refunded)',
                    'price'               => 'Цена',
                    'total'               => 'Всего',
                    'subtotal'            => 'Промежуточный итог',
                    'shipping-handling'   => 'Доставка и обработка',
                    'tax'                 => '«Налог»',
                    'discount'            => 'Скидка',
                    'tax-percent'         => '«Налоговый процент»',
                    'tax-amount'          => 'Сумма налога',
                    'discount-amount'     => 'Сумма скидки',
                    'grand-total'         => 'Общая сумма',
                    'total-paid'          => 'Итого',
                    'total-refunded'      => '«Всего возмещено»',
                    'total-due'           => '«Всего задолженность»',
                    'shipping-address'    => 'Адреса доставки',
                    'billing-address'     => 'Адрес для выставления счета',
                    'shipping-method'     => 'Способ доставки',
                    'payment-method'      => 'Способ оплаты',
                    'individual-invoice'  => 'Счет №:invoice_id',
                    'individual-shipment' => 'Отправка №:shipment_id',
                    'print'               => 'Распечатать',
                    'invoice-id'          => '«Идентификатор счета»',
                    'order-id'            => 'Номер заказа',
                    'order-date'          => 'Дата заказа',
                    'invoice-date'        => 'Дата счета',
                    'payment-terms'       => 'Условия оплаты',
                    'bill-to'             => 'Плательщик',
                    'ship-to'             => 'Доставка до',
                    'contact'             => 'Контакт',
                    'refunds'             => '«Возврат»',
                    'individual-refund'   => 'Возврат №:refund_id',
                    'adjustment-refund'   => '«Возврат корректировки»',
                    'adjustment-fee'      => '«Плата за корректировку»',
                    'cancel-btn-title'    => 'Отмена',
                    'tracking-number'     => 'Номер Отслеживания',
                    'cancel-confirm-msg'  => '«Вы уверены, что хотите отменить этот заказ?»',
                ],
            ],

            'wishlist' => [
                'page-title'           => 'список желаний',
                'title'                => 'список желаний',
                'deleteall'            => 'Удалить все',
                'confirm-delete-all'   => '«Вы уверены, что хотите удалить весь список желаний?»',
                'moveall'              => '«Переместить все товары в корзину»',
                'move-to-cart'         => '«В корзину»',
                'error'                => '«Невозможно добавить продукт в список желаний из-за неизвестных проблем, повторите попытку позже»',
                'add'                  => '«Товар успешно добавлен в список желаний»',
                'remove'               => '«Товар успешно удален из списка желаний»',
                'add-wishlist-text'    => '«Добавить товар в список желаний»',
                'remove-wishlist-text' => '«Удалить товар из списка желаний»',
                'moved'                => '«Товар успешно перемещен в корзину»',
                'option-missing'       => 'Параметры продукта отсутствуют, поэтому товар не может быть перемещен в список желаний.',
                'move-error'           => "Элемент не может быть перемещен в список желаний, повторите попытку позже",
                'success'              => '«Товар успешно добавлен в список желаний»',
                'failure'              => "Невозможно добавить товар в список желаний. Повторите попытку позже",
                'already'              => '«Товар уже есть в вашем списке желаний»',
                'removed'              => '«Товар успешно удален из списка желаний»',
                'remove-fail'          => "Элемент не может быть удален из списка желаний, повторите попытку позже",
                'empty'                => '«В вашем списке желаний нет товаров»',
                'remove-all-success'   => '«Все товары из вашего списка желаний удалены»',
                'save'                 => 'Сохранять',
                'share'                => 'Делиться',
                'share-wishlist'       => '«Поделиться списком желаний»',
                'wishlist-sharing'     => '«Обмен списком желаний»',
                'shared-link'          => '«Общая ссылка»',
                'copy'                 => 'Copy',
                'visibility'           => '«Видимость»',
                'public'               => '«Общественный»',
                'private'              => 'Частный',
                'enable'               => 'Давать возможность',
                'disable'              => 'Запрещать',
                'customer-name'        => ':name\'s Shared Wishlist',
                'enable-wishlist-info' => 'Включите общий доступ к списку желаний, чтобы получить ссылку.',
                'update-message'       => 'Настройки общего списка желаний успешно обновлены',
            ],

            'downloadable_products' => [
                'title'               => '«Загружаемые продукты»',
                'order-id'            => 'Номер заказа',
                'date'                => 'Дата',
                'name'                => 'Заголовок',
                'status'              => 'Положение дел',
                'pending'             => 'В ожидании',
                'available'           => 'Доступный',
                'expired'             => 'Истекший',
                'remaining-downloads' => '«Оставшиеся загрузки»',
                'unlimited'           => '«Безлимитный»',
                'download-error'      => 'Срок действия ссылки для скачивания устарел.',
                'payment-error'       => 'Плата за эту загрузку не произведена.',
            ],

            'review' => [
                'index' => [
                    'title'      => 'Отзывы»',
                    'page-title' => 'Отзывы»',

                ],

                'view' => [
                    'page-tile' => 'Review #:id',
                ],

                'delete' => [
                    'confirmation-message' => 'Вы уверены, что хотите удалить этот обзор?',
                ],

                'delete-all' => [
                    'title'                => 'Удалить все',
                    'confirmation-message' => '«Вы уверены, что хотите удалить все отзывы?»',
                ],
            ],
        ],
    ],

    'products' => [
        'layered-nav-title'        => '«Купить по»',
        'price-label'              => 'Так низко, как',
        'remove-filter-link-title' => 'Очистить все',
        'filter-to'                => 'к',
        'sort-by'                  => 'Сортировать по',
        'from-a-z'                 => '«От А до Я»',
        'from-z-a'                 => 'От З-А',
        'newest-first'             => 'Новички вперед',
        'oldest-first'             => 'Старейший первый',
        'cheapest-first'           => '«Сначала самые дешевые»',
        'expensive-first'          => '«Сначала дорого»',
        'show'                     => 'Показывать',
        'pager-info'               => 'Показ :показ :всего предметов',
        'description'              => 'Описание',
        'specification'            => 'Технические характеристики',
        'total-reviews'            => ':всего отзывов',
        'total-rating'             => ':total_rating Рейтинги и :total_reviews Обзоры',
        'by'                       => 'По имени',
        'up-sell-title'            => '«Мы нашли другие товары, которые могут вам понравиться!»',
        'related-product-title'    => 'Сопутствующие товары',
        'cross-sell-title'         => '«Больше вариантов»',
        'reviews-title'            => '«Рейтинги и обзоры»',
        'write-review-btn'         => 'Написать отзыв',
        'choose-option'            => 'Выберите опцию',
        'sale'                     => 'Распродажа',
        'new'                      => 'Новый',
        'empty'                    => '«Нет товаров в этой категории»',
        'add-to-cart'              => 'Добавить в корзину',
        'book-now'                 => 'Забронируйте сейчас',
        'buy-now'                  => 'Купить сейчас',
        'whoops'                   => 'Упс!',
        'quantity'                 => 'Количество',
        'in-stock'                 => 'В наличии',
        'out-of-stock'             => 'Нет на складе',
        'view-all'                 => 'Посмотреть все',
        'select-above-options'     => 'Сначала выберите указанные выше параметры.',
        'less-quantity'            => 'Количество не может быть меньше единицы.',
        'samples'                  => '«Образцы»',
        'links'                    => '«Ссылки»',
        'sample'                   => 'Образец',
        'name'                     => 'Имя',
        'qty'                      => 'кол-во',
        'starting-at'              => 'Начинается с',
        'customize-options'        => '«Настроить параметры»',
        'choose-selection'         => 'Выберите выделение',
        'your-customization'       => '«Ваша настройка»',
        'total-amount'             => 'Общая сумма',
        'none'                     => 'Никто',
        'available-for-order'      => '«Доступно для заказа»',
        'settings'                 => 'Настройки',
        'compare_options'          => '«Сравнить параметры»',
        'wishlist-options'         => '«Параметры списка желаний»',
        'offers'                   => 'Купите :кол-во по :цене за штуку и сэкономьте :скидка%',
        'tax-inclusive'            => '«Включая все налоги»',
    ],

    'buynow' => [
        'no-options' => 'Пожалуйста, выберите параметры перед покупкой этого продукта.',
    ],

    'checkout' => [
        'cart' => [
            'integrity'                 => [
                'missing_fields'  => 'Для этого продукта отсутствуют некоторые обязательные поля.',
                'missing_options' => 'Для этого продукта отсутствуют параметры.',
                'missing_links'   => 'Для этого продукта отсутствуют ссылки для скачивания.',
                'qty_missing'     => 'По крайней мере, у одного товара должно быть более 1 количества.',
                'qty_impossible'  => 'Невозможно добавить в корзину более одного из этих товаров.',
                'select_hourly_duration' => 'Выберите продолжительность слота один час.',
            ],
            'create-error'              => 'Обнаружена проблема при создании экземпляра корзины.',
            'title'                     => 'Корзина',
            'empty'                     => 'Ваша корзина пуста',
            'update-cart'               => 'Обновить корзину',
            'continue-shopping'         => 'Продолжить покупки',
            'continue-registration'     => '«Продолжить регистрацию»',
            'proceed-to-checkout'       => 'Перейти к оформлению заказа',
            'remove'                    => 'Удалять',
            'remove-link'               => 'Удалять',
            'move-to-wishlist'          => 'Добавить в список желаемого',
            'move-to-wishlist-success'  => 'Товар успешно перемещен в список желаний.',
            'move-to-wishlist-error'    => 'Не удается переместить элемент в список желаний, повторите попытку позже.',
            'add-config-warning'        => 'Пожалуйста, выберите вариант перед добавлением в корзину.',
            'quantity'                  => [
                'quantity'          => 'Количество',
                'success'           => 'Элементы корзины успешно обновлены.',
                'illegal'           => 'Количество не может быть меньше единицы.',
                'inventory_warning' => 'Запрошенное количество недоступно, повторите попытку позже.',
                'error'             => 'Не удается обновить элемент(ы) в данный момент, повторите попытку позже.',
            ],
            'item'                      => [
                'error_remove'   => 'Нет товаров для удаления из корзины.',
                'success'        => 'Товар успешно добавлен в корзину.',
                'success-remove' => 'Товар успешно удален из корзины.',
                'error-add'      => 'Товар не может быть добавлен в корзину, повторите попытку позже.',
                'inactive'       => 'Товар неактивен и был удален из корзины.',
                'inactive-add'   => 'Неактивный товар нельзя добавить в корзину.',
            ],
            'quantity-error'            => 'Запрошенное количество недоступно.',
            'cart-subtotal'             => '«Итог корзины»',
            'cart-remove-action'        => '«Вы действительно хотите это сделать?»',
            'partial-cart-update'       => '«Обновлены только некоторые продукты»',
            'link-missing'              => '',
            'event'                     => [
                'expired' => 'Срок действия этого события истек.',
            ],
            'minimum-order-message'     => 'Минимальная сумма заказа: сумма',
            'suspended-account-message' => 'Ваша учетная запись была приостановлена.',
            'inactive-account-message' =>  'Your account has been inactive.',
            'check-shipping-address'    => 'Пожалуйста, проверьте адрес доставки.',
            'check-billing-address'     => 'Пожалуйста, проверьте платежный адрес.',
            'specify-shipping-method'   => '«Укажите способ доставки».',
            'specify-payment-method'    => 'Укажите способ оплаты.',
            'rule-applied'              => 'Cart rule applied',
        ],

        'onepage' => [
            'title'               => 'Проверить',
            'information'         => 'Информация',
            'shipping'            => 'Перевозки',
            'payment'             => 'Оплата',
            'complete'            => 'Полный',
            'review'              => 'Рассмотрение',
            'billing-address'     => 'Адрес для выставления счета',
            'sign-in'             => 'Войти',
            'company-name'        => 'Название организации',
            'first-name'          => 'Имя',
            'last-name'           => 'Фамилия',
            'email'               => 'Эл. адрес',
            'address1'            => 'Адрес улицы',
            'city'                => 'Город',
            'state'               => 'Состояние',
            'select-state'        => 'Выберите регион, штат или провинцию',
            'postcode'            => 'Почтовый индекс',
            'phone'               => 'Телефон',
            'country'             => 'Страна',
            'order-summary'       => 'Итог заказа',
            'shipping-address'    => 'Адреса доставки',
            'use_for_shipping'    => '«Отправить по этому адресу»',
            'continue'            => 'Продолжать',
            'shipping-method'     => '«Выберите способ доставки»',
            'payment-methods'     => 'Выберите способ оплаты',
            'payment-method'      => 'Способ оплаты',
            'summary'             => 'Итог заказа',
            'price'               => 'Цена',
            'quantity'            => 'Количество',
            'billing-address'     => 'Адрес для выставления счета',
            'shipping-address'    => 'Адреса доставки',
            'contact'             => 'Контакт',
            'place-order'         => 'Разместить заказ',
            'new-address'         => 'Добавьте новый адрес',
            'save_as_address'     => '«Сохранить этот адрес»',
            'apply-coupon'        => 'Применить купон',
            'amt-payable'         => 'Подлежащая уплате сумма',
            'got'                 => 'Есть',
            'free'                => 'Бесплатно',
            'coupon-used'         => '«Купон использован»',
            'applied'             => 'Применяемый',
            'back'                => 'Назад',
            'cash-desc'           => 'Оплата при доставке',
            'money-desc'          => 'Перевод денег',
            'paypal-desc'         => '«Стандарт PayPal»',
            'free-desc'           => '«Это бесплатная доставка»',
            'flat-desc'           => '«Это фиксированная ставка»',
            'password'            => 'Пароль',
            'login-exist-message' => 'У вас уже есть у нас учетная запись. Войдите или продолжите как гость.',
            'enter-coupon-code'   => 'Введите код купона',
        ],

        'total' => [
            'order-summary'       => 'Итог заказа',
            'sub-total'           => 'Предметы',
            'grand-total'         => 'Общая сумма',
            'delivery-charges'    => 'Плата за доставку',
            'tax'                 => 'налог',
            'discount'            => 'Скидка',
            'price'               => 'цена',
            'disc-amount'         => 'Сумма со скидкой',
            'new-grand-total'     => 'Новый общий итог»',
            'coupon'              => 'Купон',
            'coupon-applied'      => 'Примененный купон',
            'remove-coupon'       => 'Удалить купон',
            'cannot-apply-coupon' => 'Невозможно применить купон',
            'invalid-coupon'      => 'Код купона недействителен.',
            'success-coupon'      => 'Код купона успешно применен.',
            'coupon-apply-issue'  => 'Код купона не может быть применен.',
            'coupon-already-applied' => 'Coupon code already applied.',
        ],

        'success' => [
            'title'         => 'Заказ успешно размещен',
            'thanks'        => 'Спасибо за ваш заказ!',
            'order-id-info' => 'Идентификатор вашего заказа #:order_id',
            'info'          => 'Мы вышлем вам по электронной почте детали вашего заказа и информацию для отслеживания',
        ],
    ],

    'mail' => [
        'order' => [
            'subject'           => '«Подтверждение нового заказа»',
            'heading'           => 'Подтверждение заказа!',
            'dear'              => '«Уважаемый :customer_name»',
            'dear-admin'        => 'Уважаемый :admin_name',
            'greeting'          => 'Спасибо за ваш заказ :order_id, размещенный на :created_at',
            'greeting-admin'    => 'Идентификатор заказа :order_id размещен на :created_at',
            'summary'           => '«Сводка заказа»',
            'shipping-address'  => 'Адреса доставки',
            'billing-address'   => 'Адрес для выставления счета',
            'contact'           => 'Контакт',
            'shipping'          => 'Способ доставки',
            'payment'           => 'Способ оплаты',
            'price'             => 'Цена',
            'quantity'          => 'Количество',
            'subtotal'          => 'Промежуточный итог',
            'shipping-handling' => 'Доставка и обработка',
            'tax'               => '«Налог»',
            'discount'          => 'Скидка',
            'grand-total'       => 'Общая сумма',
            'final-summary'     => '«Спасибо, что проявили интерес к нашему магазину, мы вышлем вам номер для отслеживания после отправки»',
            'help'              => 'Если вам нужна какая-либо помощь, пожалуйста, свяжитесь с нами по адресу: support_email',
            'thanks'            => 'Спасибо!',

            'comment' => [
                'subject'       => 'New comment added to your order #:order_id',
                'dear'          => 'Dear :customer_name',
                'final-summary' => 'Thanks for showing your interest in our store',
                'help'          => 'If you need any kind of help please contact us at :support_email',
                'thanks'        => 'Thanks!',
            ],

            'cancel' => [
                'subject'           => '«Подтверждение отмены заказа»',
                'heading'           => 'Заказ отменен',
                'dear'              => '«Уважаемый :customer_name»',
                'greeting'          => '«Ваш заказ с идентификатором заказа :order_id, размещенный на :created_at, был отменен»',
                'summary'           => '«Сводка заказа»',
                'shipping-address'  => 'Адреса доставки',
                'billing-address'   => 'Адрес для выставления счета',
                'contact'           => 'Контакт',
                'shipping'          => 'Способ доставки',
                'payment'           => 'Способ оплаты',
                'subtotal'          => 'Промежуточный итог',
                'shipping-handling' => 'Доставка и обработка',
                'tax'               => '«Налог»',
                'discount'          => 'Скидка',
                'grand-total'       => 'Общая сумма',
                'final-summary'     => '«Спасибо, что проявили интерес к нашему магазину»',
                'help'              => 'Если вам нужна какая-либо помощь, пожалуйста, свяжитесь с нами по адресу: support_email',
                'thanks'            => 'Спасибо!',
            ],
        ],

        'invoice' => [
            'heading'  => 'Ваш счет №:invoice_id для заказа №:order_id',
            'subject'  => 'Счет за ваш заказ #:order_id',
            'summary'  => '«Сводка счета-фактуры»',
            'reminder' => [
                'subject'                                          => '«Напоминание о счете»',
                'your-invoice-is-overdue'                          => 'Ваш счет :invoice просрочен на :time.',
                'please-make-your-payment-as-soon-as-possible'     => 'Пожалуйста, произведите оплату как можно скорее.',
                'if-you-ve-already-paid-just-disregard-this-email' => 'Если вы уже заплатили, просто проигнорируйте это письмо.',
            ],
        ],

        'shipment' => [
            'heading'           => 'Отгрузка #:shipment_id была сгенерирована для Заказа #:order_id',
            'inventory-heading' => 'Новая поставка #:shipment_id была сгенерирована для Заказа #:order_id',
            'subject'           => 'Отправка для вашего заказа #:order_id',
            'inventory-subject' => 'Создано новое отправление для Заказа №:order_id',
            'summary'           => '«Сводка по отгрузке»',
            'carrier'           => 'Перевозчик',
            'tracking-number'   => 'Номер Отслеживания',
            'greeting'          => 'Заказ :order_id был размещен на :created_at',
        ],

        'refund' => [
            'heading'           => 'Ваш возврат #:refund_id для заказа #:order_id',
            'subject'           => 'Возврат средств за ваш заказ #:order_id',
            'summary'           => '«Сводка возврата»',
            'adjustment-refund' => '«Возврат корректировки»',
            'adjustment-fee'    => '«Плата за корректировку»',
        ],

        'forget-password' => [
            'subject'        => '«Сброс пароля клиента»',
            'dear'           => '«Дорогой: имя»',
            'info'           => '«Вы получили это письмо, потому что мы получили запрос на сброс пароля для вашей учетной записи»',
            'reset-password' => 'Сброс пароля',
            'final-summary'  => '«Если вы не запрашивали сброс пароля, никаких дальнейших действий не требуется»',
            'thanks'         => 'Спасибо!',
        ],

        'update-password' => [
            'subject' => '«Пароль обновлен»',
            'dear'    => '«Дорогой: имя»',
            'info'    => 'Вы получили это письмо, потому что обновили свой пароль.',
            'thanks'  => 'Спасибо!',
        ],

        'customer' => [
            'new' => [
                'dear'           => '«Уважаемый :customer_name»',
                'username-email' => 'Имя пользователя/электронная почта',
                'subject'        => '«Регистрация нового клиента»',
                'password'       => 'Пароль',
                'summary'        => 'Ваш аккаунт был создан.
                Данные вашей учетной записи приведены ниже: ',
                'thanks'         => 'Спасибо!',
            ],

            'registration' => [
                'subject'               => '«Регистрация нового клиента»',
                'customer-registration' => '«Клиент успешно зарегистрирован»',
                'dear'                  => '«Уважаемый :customer_name»',
                'dear-admin'            => 'Уважаемый :admin_name',
                'greeting'              => '«Добро пожаловать и спасибо за регистрацию у нас!»',
                'greeting-admin'        => 'У вас есть одна новая регистрация клиента.',
                'summary'               => '«Ваша учетная запись успешно создана, и вы можете войти в систему, используя свой адрес электронной почты и пароль. После входа в систему вы сможете получить доступ к другим услугам, включая просмотр прошлых заказов, списков желаний и редактирование информации вашей учетной записи.',
                'thanks'                => 'Спасибо!',
            ],

            'verification' => [
                'heading' => config('приложение.имя') . ' - Подтверждение адреса электронной почты',
                'subject' => '«Проверочная почта»',
                'verify'  => 'Подтвердите ваш аккаунт',
                'summary' => 'Это письмо для подтверждения того, что введенный вами адрес электронной почты принадлежит вам.
                Пожалуйста, нажмите кнопку «Подтвердить свою учетную запись» ниже, чтобы подтвердить свою учетную запись.',
            ],

            'subscription' => [
                'subject'     => '«Электронная почта для подписки»',
                'greeting'    => ' Добро пожаловать в ' . config('приложение.имя') . '- Подписка по электронной почте',
                'unsubscribe' => '«Отписаться»',
                'summary'     => "«Спасибо, что отправили меня в свой почтовый ящик. Давно вы не читали». config('приложение.имя') . ', и мы не хотим перегружать ваш почтовый ящик. Если вы все еще не хотите получать
                последние новости маркетинга по электронной почте, тогда обязательно нажмите кнопку ниже.",
            ],
        ],
    ],

    'webkul' => [
        'copy-right' => '© Copyright :год Webkul Software, Все права защищены',
    ],

    'response' => [
        'create-success' => ':имя успешно создано.',
        'update-success' => ':имя успешно обновлено.',
        'delete-success' => ':имя успешно удалено.',
        'submit-success' => ': имя успешно отправлено.',
    ],
];
?>