@extends('shop::layouts.master')

@inject ('reviewHelper', 'Webkul\Product\Helpers\Review')

@php
    $total = $reviewHelper->getTotalReviews($product);
    $avgRatings = $reviewHelper->getAverageRating($product);
    $avgStarRating = round($avgRatings);
@endphp

@section('page_title')
    {{ trim($product->meta_title) != "" ? $product->meta_title : $product->name }}
@stop

@section('full-content-wrapper')
{!! view_render_event('bagisto.shop.products.view.before', ['product' => $product]) !!}

<div class="row no-margin">
    <section class="col-12 product-detail">
        <div class="layouter">
            <product-view>
                <div class="form-container">
                    @csrf()
                    <input type="hidden" name="product_id" value="{{ $product->product_id }}">

                    {{-- =====================
                         HERO: IMAGE + BUY BOX
                         ===================== --}}
                    <div class="row product-hero">

                        {{-- LEFT: GALLERY --}}
                        <div class="col-lg-5 col-md-6">
                            @include ('shop::products.view.gallery')
                        </div>

                        {{-- RIGHT: BUY BOX --}}
                        <div class="col-lg-7 col-md-6 product-buy-box">
                        <div class="info clean-product-info">

    {{-- Product name --}}
    <h1 class="product-title">
        {{ $product->name }}
    </h1>

    {{-- Price + Stock in one line --}}
    <div class="price-stock-row">
        <span class="price-amount">
            @include ('shop::products.price', ['product' => $product])
        </span>

        @if ($product->getTypeInstance()->isSaleable())
            <span class="stock-status">In Stock</span>
        @else
            <span class="stock-status out">Out of Stock</span>
        @endif
    </div>

    {{-- Quantity --}}
    <div class="product-quantity">
        <quantity-changer></quantity-changer>
    </div>

    <br>

    {{-- Actions --}}
    <div class="product-actions">
        @include ('shop::products.buy-now', ['product' => $product])

        @include ('shop::products.add-to-cart', [
            'form' => false,
            'product' => $product,
            'showCartIcon' => false,
        ])
    </div>

</div>




                    </div>

                    {{-- =====================
                         FULL WIDTH REPORT CONTENT
                         ===================== --}}
                    {{-- =====================
     REPORT SECTION (2 COLUMN)
     ===================== --}}
<div class="row product-report-content">

    {{-- LEFT: REPORT CONTENT --}}
    <div class="col-lg-8 col-md-7 report-left">

        @include ('shop::products.view.short-description')

        @include ('shop::products.view.attributes')

        @include ('shop::products.view.description')

    </div>

    {{-- RIGHT: REPORT SIDEBAR --}}
    <div class="col-lg-4 col-md-5 report-sidebar">



    
        {{-- Payment methods --}}
  <div class="report-card payment-card">
    <h4>Payment Methods Accepted</h4>

    <div style="display:flex;align-items:center;gap:16px;flex-wrap:wrap">

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png"
            alt="Visa"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg"
            alt="Mastercard"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/b/b5/PayPal.svg"
            alt="PayPal"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <!-- <img
            src="https://upload.wikimedia.org/wikipedia/commons/0/01/Stripe_logo%2C_revised_2016.svg"
            alt="Stripe"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        > -->

    </div>
</div>


       

    </div>
</div>


                </div>
            </product-view>
        </div>
    </section>
</div>

{!! view_render_event('bagisto.shop.products.view.after', ['product' => $product]) !!}
@endsection

@push('scripts')
<script type="text/javascript" src="{{ asset('vendor/webkul/ui/assets/js/ui.js') }}"></script>

<script type="text/x-template" id="product-view-template">
    <form
        method="POST"
        id="product-form"
        @submit.prevent="onSubmit"
        action="{{ route('cart.add', $product->product_id) }}"
    >
        <input type="hidden" name="is_buy_now" v-model="is_buy_now">
        <slot></slot>
    </form>
</script>

<script>
Vue.component('product-view', {
    template: '#product-view-template',
    data() {
        return { is_buy_now: 0 }
    },
    methods: {
        onSubmit(e) {
            this.is_buy_now = e.submitter?.classList.contains('buynow') ? 1 : 0;
            this.$el.submit();
        }
    }
});
</script>
@endpush
