@inject ('productViewHelper', 'Webkul\Product\Helpers\View')

{!! view_render_event('bagisto.shop.products.view.attributes.before', ['product' => $product]) !!}

@php
    $customAttributeValues = $productViewHelper->getAdditionalData($product);
@endphp

@if ($customAttributeValues)
    @foreach ($customAttributeValues as $attribute)

        @if (!empty($attribute['value']))
        <section class="report-section">
            <h2 class="report-heading">
                {{ $attribute['label'] ?? $attribute['admin_name'] }}
            </h2>

            <div class="report-content">
                @if ($attribute['type'] == 'file')
                    <a href="{{ route('shop.product.file.download', [$product->product_id, $attribute['id']]) }}" class="report-download">
                        Download
                    </a>

                @elseif ($attribute['type'] == 'image')
                    <img src="{{ Storage::url($attribute['value']) }}" class="report-image" alt="">

                @else
                    {!! nl2br(e($attribute['value'])) !!}
                @endif
            </div>
        </section>
        @endif

    @endforeach
@endif

{!! view_render_event('bagisto.shop.products.view.attributes.after', ['product' => $product]) !!}
