<?php $reviewHelper = app('Webkul\Product\Helpers\Review'); ?>

<?php
    $total = $reviewHelper->getTotalReviews($product);
    $avgRatings = $reviewHelper->getAverageRating($product);
    $avgStarRating = round($avgRatings);
?>

<?php $__env->startSection('page_title'); ?>
    <?php echo e(trim($product->meta_title) != "" ? $product->meta_title : $product->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('full-content-wrapper'); ?>
<?php echo view_render_event('bagisto.shop.products.view.before', ['product' => $product]); ?>


<div class="row no-margin">
    <section class="col-12 product-detail">
        <div class="layouter">
            <product-view>
                <div class="form-container">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="product_id" value="<?php echo e($product->product_id); ?>">

                    
                    <div class="row product-hero">

                        
                        <div class="col-lg-5 col-md-6">
                            <?php echo $__env->make('shop::products.view.gallery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        
                        <div class="col-lg-7 col-md-6 product-buy-box">
                        <div class="info clean-product-info">

    
    <h1 class="product-title">
        <?php echo e($product->name); ?>

    </h1>

    
    <div class="price-stock-row">
        <span class="price-amount">
            <?php echo $__env->make('shop::products.price', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </span>

        <?php if($product->getTypeInstance()->isSaleable()): ?>
            <span class="stock-status">In Stock</span>
        <?php else: ?>
            <span class="stock-status out">Out of Stock</span>
        <?php endif; ?>
    </div>

    
    <div class="product-quantity">
        <quantity-changer></quantity-changer>
    </div>

    <br>

    
    <div class="product-actions">
        <?php echo $__env->make('shop::products.buy-now', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('shop::products.add-to-cart', [
            'form' => false,
            'product' => $product,
            'showCartIcon' => false,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

</div>




                    </div>

                    
                    
<div class="row product-report-content">

    
    <div class="col-lg-8 col-md-7 report-left">

        <?php echo $__env->make('shop::products.view.short-description', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('shop::products.view.attributes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('shop::products.view.description', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>

    
    <div class="col-lg-4 col-md-5 report-sidebar">



    
        
  <div class="report-card payment-card">
    <h4>Payment Methods Accepted</h4>

    <div style="display:flex;align-items:center;gap:16px;flex-wrap:wrap">

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png"
            alt="Visa"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg"
            alt="Mastercard"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <img
            src="https://upload.wikimedia.org/wikipedia/commons/b/b5/PayPal.svg"
            alt="PayPal"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        >

        <!-- <img
            src="https://upload.wikimedia.org/wikipedia/commons/0/01/Stripe_logo%2C_revised_2016.svg"
            alt="Stripe"
            style="height:26px;width:auto;max-width:80px;object-fit:contain;"
        > -->

    </div>
</div>


       

    </div>
</div>


                </div>
            </product-view>
        </div>
    </section>
</div>

<?php echo view_render_event('bagisto.shop.products.view.after', ['product' => $product]); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('vendor/webkul/ui/assets/js/ui.js')); ?>"></script>

<script type="text/x-template" id="product-view-template">
    <form
        method="POST"
        id="product-form"
        @submit.prevent="onSubmit"
        action="<?php echo e(route('cart.add', $product->product_id)); ?>"
    >
        <input type="hidden" name="is_buy_now" v-model="is_buy_now">
        <slot></slot>
    </form>
</script>

<script>
Vue.component('product-view', {
    template: '#product-view-template',
    data() {
        return { is_buy_now: 0 }
    },
    methods: {
        onSubmit(e) {
            this.is_buy_now = e.submitter?.classList.contains('buynow') ? 1 : 0;
            this.$el.submit();
        }
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('shop::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bagisto/resources/themes/velocity/views/products/view.blade.php ENDPATH**/ ?>