<?php $productViewHelper = app('Webkul\Product\Helpers\View'); ?>

<?php echo view_render_event('bagisto.shop.products.view.attributes.before', ['product' => $product]); ?>


<?php
    $customAttributeValues = $productViewHelper->getAdditionalData($product);
?>

<?php if($customAttributeValues): ?>
    <?php $__currentLoopData = $customAttributeValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php if(!empty($attribute['value'])): ?>
        <section class="report-section">
            <h2 class="report-heading">
                <?php echo e($attribute['label'] ?? $attribute['admin_name']); ?>

            </h2>

            <div class="report-content">
                <?php if($attribute['type'] == 'file'): ?>
                    <a href="<?php echo e(route('shop.product.file.download', [$product->product_id, $attribute['id']])); ?>" class="report-download">
                        Download
                    </a>

                <?php elseif($attribute['type'] == 'image'): ?>
                    <img src="<?php echo e(Storage::url($attribute['value'])); ?>" class="report-image" alt="">

                <?php else: ?>
                    <?php echo nl2br(e($attribute['value'])); ?>

                <?php endif; ?>
            </div>
        </section>
        <?php endif; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<?php echo view_render_event('bagisto.shop.products.view.attributes.after', ['product' => $product]); ?>

<?php /**PATH C:\xampp\htdocs\bagisto/resources/themes/velocity/views/products/view/attributes.blade.php ENDPATH**/ ?>